package com.wecloud.im.action;

import com.wecloud.dispatch.annotation.ActionMapping;
import com.wecloud.im.param.ImMsgReceivedStatusUpdate;
import com.wecloud.im.param.MsgReadStatusUpdateParam;
import com.wecloud.im.param.UpdateMsgReadStatusByConversationParam;
import com.wecloud.im.service.ImInboxService;
import com.wecloud.im.ws.model.WsResponse;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author luozh
 * @Date 2022年04月02日 16:39
 * @Version 1.0
 */
@Slf4j
@Component
@ActionMapping(value = "/im/inbox")
@Api(value = "ws-消息收件箱API", tags = {"ws-消息收件箱"})
public class InboxAction {

    @Autowired
    private ImInboxService imInboxService;

    /**
     * 消息修改为已接收状态
     */
    @ActionMapping("/msgReceivedUpdate")
    @ApiOperation(value = "消息修改为已接收状态")
    public WsResponse<Boolean> updateImMsgReceived(@RequestParam(value = "data") @Validated ImMsgReceivedStatusUpdate imMsgReceivedUpdate) throws Exception {
        imInboxService.updateImMsgReceived(imMsgReceivedUpdate);
        return WsResponse.ok();
    }

    /**
     * 消息修改为已读状态
     */
    @ActionMapping("/msgReadUpdate")
    @ApiOperation(value = "消息修改为已读状态")
    public WsResponse<Boolean> updateInMsgReadUpdate(@RequestParam(value = "data") MsgReadStatusUpdateParam msgReadStatusUpdateParam) throws Exception {
        if (CollectionUtils.isEmpty(msgReadStatusUpdateParam.getMsgIds())) {
            return WsResponse.fail(ApiCode.PARAMETER_EXCEPTION);
        }
        imInboxService.updateImMsgRead(msgReadStatusUpdateParam);
        return WsResponse.ok();
    }

    /**
     * 会话消息修改为已读状态
     */
    @ActionMapping("/updateMsgReadStatusByConversation")
    @ApiOperation(value = "会话消息修改为已读状态")
    public WsResponse<Boolean> updateMsgReadStatusByConversation(@RequestParam(value = "data") UpdateMsgReadStatusByConversationParam param) throws Exception {
        if (param.getConversationId() == null) {
            return WsResponse.fail(ApiCode.PARAMETER_EXCEPTION);
        }
        return WsResponse.ok(imInboxService.updateMsgReadStatusByConversation(param));
    }
}
