package com.wecloud.im.action;

import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;

import com.wecloud.dispatch.annotation.ActionMapping;
import com.wecloud.im.param.ImClientBlacklistPageParam;
import com.wecloud.im.param.ImClientBlacklistQueryVo;
import com.wecloud.im.param.add.ImClientBlacklistUpdate;
import com.wecloud.im.service.ImClientBlacklistService;
import com.wecloud.im.ws.model.WsResponse;
import com.wecloud.im.ws.model.request.PushVO;

/**
 * ws 黑名单
 * @Author luozh
 * @Date 2022年04月02日 09:20
 * @Version 1.0
 */
@Slf4j
@Component
@ActionMapping(value = "/im/blacklist")
@Api(value = "ws-黑名单API", tags = {"ws-黑名单"})
public class BlacklistAction {

    @Autowired
    private ImClientBlacklistService imClientBlacklistService;

    /**
     * 添加黑名单
     */
    @ActionMapping("/add")
    @ApiOperation(value = "拉入黑名单")
    public WsResponse<Boolean> addImClientBlacklist(@RequestParam(value = "data") ImClientBlacklistUpdate clientBlacklistUpdate) {
        imClientBlacklistService.addImClientBlacklist(clientBlacklistUpdate);
        return WsResponse.ok();
    }


    /**
     * 删除黑名单
     */
    @ActionMapping("/delete")
    @ApiOperation(value = "移出黑名单")
    public WsResponse<Boolean> deleteImClientBlacklist(@RequestParam(value = "data") ImClientBlacklistUpdate clientBlacklistUpdate) {
        imClientBlacklistService.removeImClientBlacklist(clientBlacklistUpdate);
        return WsResponse.ok();
    }

    /**
     * 黑名单分页列表
     */
    @ActionMapping("/getPageList")
    @OperationLog(name = "黑名单分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "黑名单分页列表")
    public WsResponse<Paging<ImClientBlacklistQueryVo>> getImClientBlacklistPageList(@RequestParam(value = "data") ImClientBlacklistPageParam clientBlacklistUpdate) {
        Paging<ImClientBlacklistQueryVo> blacklist =
                imClientBlacklistService.getImClientBlacklistPageList(clientBlacklistUpdate);
        return WsResponse.ok(blacklist);
    }
}
