package com.wecloud.im.param;

import com.wecloud.im.sdk.enums.ChatTypeEnum;
import com.wecloud.im.ws.enums.MsgTypeEnum;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @program: wecloud_im_server
 * @description: 消息
 * @author: cql
 * @create: 2022-10-19 14:25
 **/
@Data
@Accessors(chain = true)
public class WeCloudMessageVo implements Serializable {

    private Long id;

    /**
     * 发送者用户id
     */
    private Long fromUserId;

    /**
     * 目标id 为群组时是wecloud群组id，为饲料时是目标用户id
     */
    private Long targetId;

    /**
     * 消息内容
     */
    private String content;

    /**
     * 消息类型 TEXT 文本 PIC图片 VIDEO 视频
     */
    private MsgTypeEnum msgType;


    /**
     * 会话类型SINGLE 单聊 NORMAL_GROUP 群聊
     */
    private ChatTypeEnum chatType;

    /**
     * 消息发送时间
     */
    private Date msgSendTime;

    /**
     * 消息撤回时间
     */
    private Date withdrawTime;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date updateTime;
}
