package com.wecloud.im.service;

import com.wecloud.im.entity.ImClientBlacklist;
import com.wecloud.im.param.ImClientBlacklistPageParam;
import com.wecloud.im.param.ImClientBlacklistQueryVo;
import com.wecloud.im.param.add.ImClientBlacklistUpdate;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 黑名单 服务类
 *
 * @author wei
 * @since 2021-06-17
 */
public interface ImClientBlacklistService extends BaseService<ImClientBlacklist> {


    /**
     * 当前客户端是否被拉黑
     *
     * @param currentClient 当前客户端
     * @param toClient      对方客户端
     * @return
     */
    boolean isBeBlack(Long currentClient, Long toClient);

    /**
     * 拉入黑名单
     *
     * @param imClientBlacklistUpdate
     * @return
     * @throws Exception
     */
    ApiResult<Boolean> addImClientBlacklist(ImClientBlacklistUpdate imClientBlacklistUpdate) throws Exception;

    /**
     * 移出黑名单
     *
     * @param imClientBlacklistUpdate
     * @return
     * @throws Exception
     */
    ApiResult<Boolean> removeImClientBlacklist(ImClientBlacklistUpdate imClientBlacklistUpdate) throws Exception;


    /**
     * 保存
     *
     * @param imClientBlacklist
     * @return
     * @throws Exception
     */
    boolean saveImClientBlacklist(ImClientBlacklist imClientBlacklist) throws Exception;

    /**
     * 修改
     *
     * @param imClientBlacklist
     * @return
     * @throws Exception
     */
    boolean updateImClientBlacklist(ImClientBlacklist imClientBlacklist) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteImClientBlacklist(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    ImClientBlacklistQueryVo getImClientBlacklistById(Long id) throws Exception;

//        /**
//         * 获取分页对象
//         *
//         * @param imClientBlacklistPageParam
//         * @return
//         * @throws Exception
//         */
//        Paging<ImClientBlacklistQueryVo> getImClientBlacklistPageList(ImClientBlacklistPageParam imClientBlacklistPageParam) throws Exception;


    /**
     * 获取分页对象
     *
     * @return
     * @throws Exception
     */
    ApiResult<Paging<ImClientBlacklistQueryVo>> getImClientBlacklistPageList(ImClientBlacklistPageParam imClientBlacklistPageParam) throws Exception;

}
