package com.wecloud.im.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <pre>
 * 飞机型号表 查询结果对象
 * </pre>
 *
 * @author wei
 * @date 2020-10-09
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "PlainTypeQueryVo对象")
public class PlainTypeQueryVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("系列类型，0-尊享系列 , 1-奢享系列 ,2-普通系列")
    private Integer seriesType;

    @ApiModelProperty("飞机名称")
    private String name;

    @ApiModelProperty("飞机图片地址")
    private String imgUrl;

    @ApiModelProperty("状态，0-正常，1-禁用，99-删除")
    private Integer status;

    @ApiModelProperty("创建时间（时间戳）")
    private Long createTime;

    @ApiModelProperty("更新时间（时间戳）")
    private Long updateTime;
}
