package com.wecloud.im.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <pre>
 * 捐款记录 查询结果对象
 * </pre>
 *
 * @author hewei
 * @date 2021-02-25
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "DonationRecordQueryVo对象")
public class DonationRecordQueryVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private Long id;
//
//    @ApiModelProperty("捐款人id")
//    private Long fkUserId;

    @ApiModelProperty("捐款金额")
    private BigDecimal money;

    @ApiModelProperty("捐款用途;直接录入字符串: 助学助教,资助病残;慰问孤老,其他")
    private String purpose;

    @ApiModelProperty("捐款方式;1正常.2匿名,替他人捐款记录在donation_r agent表")
    private Integer way;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建时间")
    private Date createTime;

//    @ApiModelProperty("修改时间")
//    private Date updateTime;

    @ApiModelProperty("是否为别人替我捐款")
    private Integer isReplace;
}