package com.wecloud.im.service;

import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.wecloud.im.entity.DonationRecord;
import com.wecloud.im.param.DonationRecordPageParam;
import com.wecloud.im.param.app.DonationRecordAdd;
import com.wecloud.im.vo.DonationRankAndTotal;
import com.wecloud.im.vo.DonationRecordQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

import java.util.List;

/**
 * 捐款记录 服务类
 *
 * @author hewei
 * @since 2021-02-25
 */
public interface DonationRecordService extends BaseService<DonationRecord> {


    /**
     * 查询捐款排名和总捐款
     *
     * @param userId
     * @return
     */
    DonationRankAndTotal getDonationRankAndTotal(Long userId);

    /**
     * 保存
     *
     * @param donationRecord
     * @return
     * @throws Exception
     */
    boolean saveDonationRecord(DonationRecord donationRecord) throws Exception;


    /**
     * 回调
     */
    String donationOrderNotifyResult(String xmlData);


    /**
     * 我要捐款
     *
     * @param donationRecordAdd
     * @return
     * @throws Exception
     */
    ApiResult<WxPayMpOrderResult> add(DonationRecordAdd donationRecordAdd) throws Exception;

    /**
     * 修改
     *
     * @param donationRecord
     * @return
     * @throws Exception
     */
    boolean updateDonationRecord(DonationRecord donationRecord) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteDonationRecord(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    DonationRecordQueryVo getDonationRecordById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param donationRecordPageParam
     * @return
     * @throws Exception
     */
    Paging<DonationRecordQueryVo> getDonationRecordPageList(DonationRecordPageParam donationRecordPageParam) throws Exception;

    ApiResult<List<DonationRecord>> getDonationRecordAllList() throws Exception;


}
