package com.wecloud.im.service;

import com.wecloud.im.entity.DonationAgent;
import com.wecloud.im.param.DonationAgentPageParam;
import com.wecloud.im.vo.DonationAgentQueryVo;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 替他人捐款记录表 服务类
 *
 * @author hewei
 * @since 2021-02-25
 */
public interface DonationAgentService extends BaseService<DonationAgent> {

        /**
         * 保存
         *
         * @param donationAgent
         * @return
         * @throws Exception
         */
        boolean saveDonationAgent(DonationAgent donationAgent)throws Exception;

        /**
         * 修改
         *
         * @param donationAgent
         * @return
         * @throws Exception
         */
        boolean updateDonationAgent(DonationAgent donationAgent)throws Exception;

        /**
         * 删除
         *
         * @param id
         * @return
         * @throws Exception
         */
        boolean deleteDonationAgent(Long id)throws Exception;

            /**
             * 根据ID获取查询对象
             *
             * @param id
             * @return
             * @throws Exception
             */
        DonationAgentQueryVo getDonationAgentById(Long id)throws Exception;

        /**
         * 获取分页对象
         *
         * @param donationAgentPageParam
         * @return
         * @throws Exception
         */
        Paging<DonationAgentQueryVo> getDonationAgentPageList(DonationAgentPageParam donationAgentPageParam) throws Exception;

        }
