package com.wecloud.im.service;

import com.wecloud.im.entity.AppUser;
import com.wecloud.im.param.app.AppSmsRegisterParam;
import com.wecloud.im.param.app.AppUserInfoParam;
import com.wecloud.im.vo.app.LoginAppUserTokenVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;

import java.util.List;
import java.util.Set;

public interface AppUserApiService {

    /**
     * 注册
     *
     * @param loginParam
     * @param language
     * @return
     * @throws Exception
     */
    ApiResult<LoginAppUserTokenVo> register(AppSmsRegisterParam loginParam, String language) throws Exception;
//    ApiResult<LoginAppUserTokenVo> login(AppSmsRegisterParam loginParam, String language) throws Exception;

    /**
     * 修改或补充用户信息
     *
     * @param appUserInfoParam
     * @return
     * @throws Exception
     */
    boolean updateAppUser(AppUserInfoParam appUserInfoParam) throws Exception;

    /**
     * 修改手机号
     *
     * @param phoneArea
     * @param phone
     * @param code
     * @return
     * @throws Exception
     */
    ApiResult<Boolean> updatePhone(String phoneArea, String phone, String code, String codeNew) throws Exception;


    /**
     * 获取用户信息
     *
     * @param userId
     * @return
     */
    AppUser getUserInfo(Long userId);

    /**
     * 批量获取用户信息
     *
     * @param uids
     * @return
     */
    ApiResult<List<AppUser>> getAppUserList(Set<Long> uids);


}
