package com.wecloud.im.param.app;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 捐款记录
 *
 * @author hewei
 * @since 2021-02-25
 */
@Data
public class DonationRecordAdd implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "捐款金额", required = true)
    private BigDecimal money;

    @ApiModelProperty(value = "捐款用途;直接录入字符串: 助学助教,资助病残;慰问孤老,其他", required = true)
    private String purpose;

    @ApiModelProperty(value = "捐款方式;1正常,2匿名", required = true)
    private Integer way;

    @ApiModelProperty(value = "是否替别人捐款,1是,0不是", required = true)
    private Integer isReplace;

    @ApiModelProperty("捐款接收用户手机号,isReplace=1时必传")
    private String userPhone;

    @ApiModelProperty("手机区号,isReplace=1时必传")
    private String phoneArea;
}
