package com.wecloud.im.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 系统通知表
 *
 * @author xxx
 * @since 2020-11-06
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "SysNotice对象")
public class SysNotice extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空")
    @ApiModelProperty("id")
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @ApiModelProperty("主题")
    private String theme;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("创建时间（时间戳）")
    private Date createTime;

    @ApiModelProperty("更新时间（时间戳）")
    private Date updateTime;

    @ApiModelProperty("状态，0-正常，1-禁用，99-删除")
    private Integer status;

}
