package com.wecloud.im.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 捐款记录
 *
 * @author hewei
 * @since 2021-02-25
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "DonationRecord对象")
public class DonationRecord extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空", groups = {Update.class})
    @ApiModelProperty("主键")
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @NotNull(message = "外键_捐款人_用户表id不能为空")
    @ApiModelProperty("外键_捐款人_用户表id")
    private Long fkUserId;

    @ApiModelProperty("捐款金额")
    private BigDecimal money;

    @ApiModelProperty("捐款用途;直接录入字符串: 助学助教,资助病残;慰问孤老,其他")
    private String purpose;

    @ApiModelProperty("捐款方式;1正常.2匿名,替他人捐款记录在donation_r agent表")
    private Integer way;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("是否为别人替我捐款")
    private Integer isReplace;

    @ApiModelProperty("微信商家订单id")
    private String wxMerPayId;

    @ApiModelProperty("支付状态,1已支付, 0未支付")
    private Integer payStatus;

    @ApiModelProperty("支付时间")
    private Date payTime;


}
