package com.wecloud.im.controller;

import com.wecloud.im.entity.VipPrice;
import com.wecloud.im.service.VipPriceService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 会员价格表 控制器
 *
 * @author xxx
 * @since 2021-03-11
 */
@Slf4j
@RestController
@RequestMapping("/vipPrice")
@Api(value = "会员价格表API", tags = {"会员价格表"})
public class VipPriceController extends BaseController {

    @Autowired
    private VipPriceService vipPriceService;

    /**
     * 会员价格表所有列表
     */
    @PostMapping("/getAllList")
    @OperationLog(name = "会员价格表所有列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "会员价格表所有列表")
    public ApiResult<List<VipPrice>> getVipPricePageList() throws Exception {
        return ApiResult.ok(vipPriceService.list());
    }


//    /**
//     * 会员价格表分页列表
//     */
//    @PostMapping("/getPageList")
//    @OperationLog(name = "会员价格表分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "会员价格表分页列表")
//    public ApiResult<Paging<VipPriceQueryVo>> getVipPricePageList(@Validated @RequestBody VipPricePageParam vipPricePageParam) throws Exception {
//        Paging<VipPriceQueryVo> paging = vipPriceService.getVipPricePageList(vipPricePageParam);
//        return ApiResult.ok(paging);
//    }

//    /**
//     * 添加会员价格表
//     */
//    @PostMapping("/add")
//    @OperationLog(name = "添加会员价格表", type = OperationLogType.ADD)
//    @ApiOperation(value = "添加会员价格表")
//    public ApiResult<Boolean> addVipPrice(@Validated(Add.class) @RequestBody VipPrice vipPrice) throws Exception {
//        boolean flag = vipPriceService.saveVipPrice(vipPrice);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 修改会员价格表
//     */
//    @PostMapping("/update")
//    @OperationLog(name = "修改会员价格表", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改会员价格表")
//    public ApiResult<Boolean> updateVipPrice(@Validated(Update.class) @RequestBody VipPrice vipPrice) throws Exception {
//        boolean flag = vipPriceService.updateVipPrice(vipPrice);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 删除会员价格表
//     */
//    @PostMapping("/delete/{id}")
//    @OperationLog(name = "删除会员价格表", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除会员价格表")
//    public ApiResult<Boolean> deleteVipPrice(@PathVariable("id") Long id) throws Exception {
//        boolean flag = vipPriceService.deleteVipPrice(id);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 获取会员价格表详情
//     */
//    @GetMapping("/info/{id}")
//    @OperationLog(name = "会员价格表详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "会员价格表详情")
//    public ApiResult<VipPriceQueryVo> getVipPrice(@PathVariable("id") Long id) throws Exception {
//        VipPriceQueryVo vipPriceQueryVo = vipPriceService.getVipPriceById(id);
//        return ApiResult.ok(vipPriceQueryVo);
//    }


}

