package com.wecloud.im.param;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 单个用户通知
 * @Author luozh
 * @Date 2022年05月05日 11:49
 * @Version 1.0
 */
@Data
public class SingleUserNotificationParam {
    /**
     * 发送人用户id
     */
    @NotBlank(message = "发送人用户id不能为空")
    private String fromUserId;

    /**
     * 指定一个或多个用户
     */
    @NotBlank(message = "接收用户不能为空")
    private String toUserIds;

    /**
     * 消息类型
     */
    @NotBlank(message = "消息类型不能为空")
    private String messageType;

    /**
     * 消息
     */
    @NotBlank(message = "消息内容不能为空")
    private String content;

    /**
     * 指定离线推送通知中的推送内容
     */
    private String pushContent;

    /**
     * 是否存储此条消息
     */
    private Boolean persisted;

    /**
     * 推送拓展配置
     */
    private PushExtParam pushExt;

    /**
     * 会话拓展配置
     */
    private ConversationExtParam conversationExt;

}
