package com.wecloud.im.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ImStatistics每日活跃用户/群组统计")
public class ImStatistics extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空")
    @ApiModelProperty("id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @NotNull(message = "应用appid不能为空")
    @ApiModelProperty("应用appid")
    private Long fkAppid;

    @ApiModelProperty("统计类型 1用户  2群组")
    private Integer type;

    @ApiModelProperty("数据")
    private Integer data;

    @ApiModelProperty("统计的日期")
    private LocalDateTime time;

    @ApiModelProperty("总成员数")
    private Integer groupMember;

    @ApiModelProperty("创建")
    private LocalDateTime createTime;

    @ApiModelProperty("修改")
    private LocalDateTime updateTime;
}
