package com.ym.im.entity;

import com.ym.im.entity.base.BaseSocketInfo;
import io.netty.channel.socket.nio.NioSocketChannel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.HashSet;
import java.util.Set;

/**
 * @author: JJww
 * 客服
 * @Date:2019-05-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class StaffSocketInfo extends BaseSocketInfo {

    private Long staffId;

    private Set<Long> userIds;

    public Set<Long> getUserIds() {
        return userIds != null ? userIds : new HashSet<Long>();
    }

    public void setUserIds(Set<Long> userIds) {
        this.userIds = userIds;
    }

    public StaffSocketInfo() {
    }

    public StaffSocketInfo(Long staffId, Set<Long> userIds) {
        this.staffId = staffId;
        this.userIds = userIds;
    }


    public StaffSocketInfo(Long staffId, NioSocketChannel channel, Set<Long> userIds) {
        this.staffId = staffId;
        this.channel = channel;
        this.userIds = userIds;
    }
}
