package com.jumeirah.common.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <pre>
 * 商家 查询结果对象
 * </pre>
 *
 * @author wei
 * @date 2020-09-28
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "MerchantUserQueryForAppVo对象")
public class MerchantUserQueryForAppVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("航空公司名称")
    private String airlineName;

    @ApiModelProperty("在列表展示的图片url")
    private String imageListUrl;

    @ApiModelProperty("公司介绍图片url")
    private String imageCompanyIntroductionUrl;

    @ApiModelProperty("团队介绍图片url")
    private String imageTeamIntroductionUrl;

    @ApiModelProperty("优势图片url")
    private String imageAdvantageUrl;

    @ApiModelProperty("公司介绍文字")
    private String textCompanyIntroduction;

    @ApiModelProperty("团队介绍文字")
    private String textTeamIntroduction;

    @ApiModelProperty("优势介绍文字")
    private String textAdvantage;
}