package com.wecloud.im.sdk.enums;

import io.geekidea.springbootplus.framework.common.enums.BaseEnum;

/**
 * @Author wenzhida
 * @Date 2022/2/21 18:25
 * @Description 验证码验证场景枚举
 */
public enum VerifySceneEnum implements BaseEnum {

    /**
     * 1 - 用户注册
     */
    REGISTER(1, "用户注册"),

    /**
     * 2 - 重置密码验证
     */
    RESET_PWD(2, "重置密码验证"),

    /**
     * 3 - 更换手机号绑定
     */
    CHANGE_PHONE(3, "更换手机号绑定");

    VerifySceneEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final Integer code;
    private final String desc;


    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}
