package com.wecloud.im.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;

/**
 *
 * @Author luozh
 * @Date 2022年05月05日 10:08
 * @Version 1.0
 */
@Data
public class GroupChatStatusMessageParam {

    /**
     * 发送人客户端id
     */
    @NotEmpty(message = "发送人id不能为空")
    @ApiModelProperty("发送人id")
    private String fromUserId;

    /**
     * 接收群id
     */
    @NotEmpty(message = "接收群id不能为空")
    @ApiModelProperty("接收群id")
    private String toGroupIds;

    /**
     * 指定一个或多个用户
     */
    @ApiModelProperty("指定一个或多个用户")
    private String toUserIds;

    /**
     * 消息类型
     */
    @NotEmpty(message = "消息类型不能为空")
    @ApiModelProperty("消息类型")
    private String messageType;

    /**
     * 消息
     */
    @NotEmpty(message = "消息不能为空")
    @ApiModelProperty("消息")
    private String content;

    /**
     * 是否过滤黑名单
     */
    @ApiModelProperty("是否过滤黑名单")
    private Boolean includeBlacklist;

    /**
     * 发送用户是否接收
     */
    @ApiModelProperty("发送用户是否接收")
    private Boolean includeSender;
}
