package com.jumeirah.api.merchant.entity.param;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * 商家
 *
 * @author wei
 * @since 2020-09-28
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "MerchantUserAddParam对象")
public class MerchantUserAddParam extends BaseEntity {

    private static final long serialVersionUID = 1L;
    @NotBlank(message = "账号不能为空")
    @ApiModelProperty("账号")
    private String username;

    @NotBlank(message = "密码不能为空")
    @ApiModelProperty("密码")
    private String password;

    @ApiModelProperty("职位")
    private String remark;

}
