package com.wecloud.im.controller.serverapi;

import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.param.ApiImConversationMembersPageParam;
import com.wecloud.im.param.ApiImConversationMembersQueryVo;
import com.wecloud.im.param.add.ImConversationMemApiAdd;
import com.wecloud.im.service.ImApplicationService;
import com.wecloud.im.service.ImConversationMembersService;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 会话成员表 控制器
 *
 * @author wei
 * @since 2021-05-07
 */
@Slf4j
@RestController
@RequestMapping("/server/imConversationMembers")
@Api(value = "服务端rest-API-会话成员表", tags = {"服务端API-会话成员表"})
public class ApiImConversationMembersController extends BaseController {

    @Autowired
    private ImConversationMembersService imConversationMembersService;

    @Autowired
    private ImApplicationService imApplicationService;

    /**
     * 会话成员表分页列表
     */
    @PostMapping("/findList")
    @OperationLog(name = "rest-api-会话成员表分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "rest-api-会话成员表分页列表")
    public ApiResult<List<ApiImConversationMembersQueryVo>> getApiImConversationMembersList(@Validated @RequestBody ApiImConversationMembersPageParam apiImConversationMembersPageParam, @RequestHeader String appkey, @RequestHeader String appSecret) throws Exception {


        //  根据appKey从数据库查询密钥
        ImApplication imApplication = imApplicationService.getOneByAppKey(appkey);

        if (imApplication == null) {
            return ApiResult.result(ApiCode.FAIL, null);
        }

        // 校验appkey 和appSecret
        if (!imApplication.getAppSecret().equals(appSecret)) {
            return ApiResult.result(ApiCode.FAIL, null);
        }
        return imConversationMembersService.getRestApiImConversationMembersList(apiImConversationMembersPageParam, imApplication);
    }

    /**
     *  服务端api调用 将一名用户添加至会话:   ${clientID}通过${type}加入会话 -1014
     */
    @PostMapping("/add")
    @ApiOperation(value = " 服务端api调用 将一名用户添加至会话:${clientID}通过${type}加入会话 -1014")
    public ApiResult<Boolean> addImConversationMembers(@Validated(Add.class) @RequestBody ImConversationMemApiAdd imConversationMemApiAdd
            , @RequestHeader String appkey, @RequestHeader String appSecret) throws Exception {
        //  根据appKey从数据库查询密钥
        ImApplication imApplication = imApplicationService.getOneByAppKey(appkey);

        if (imApplication == null) {
            return ApiResult.result(ApiCode.FAIL, null);
        }

        // 校验appkey 和appSecret
        if (!imApplication.getAppSecret().equals(appSecret)) {
            return ApiResult.result(ApiCode.FAIL, null);
        }
        boolean flag = imConversationMembersService.addImConversationMembersApi(imConversationMemApiAdd, imApplication);
        return ApiResult.result(flag);
    }
//
//    /**
//     * 修改会话成员表
//     */
//    @PostMapping("/update")
//    @OperationLog(name = "修改会话成员表", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改会话成员表")
//    public ApiResult<Boolean> updateImConversationMembers(@Validated(Update.class) @RequestBody ImConversationMembers imConversationMembers) throws Exception {
//        boolean flag = imConversationMembersService.updateImConversationMembers(imConversationMembers);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 删除会话成员表
//     */
//    @PostMapping("/delete/{id}")
//    @OperationLog(name = "删除会话成员表", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除会话成员表")
//    public ApiResult<Boolean> deleteImConversationMembers(@PathVariable("id") Long id) throws Exception {
//        boolean flag = imConversationMembersService.deleteImConversationMembers(id);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 获取会话成员表详情
//     */
//    @GetMapping("/info/{id}")
//    @OperationLog(name = "会话成员表详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "会话成员表详情")
//    public ApiResult<ImConversationMembersQueryVo> getImConversationMembers(@PathVariable("id") Long id) throws Exception {
//        ImConversationMembersQueryVo imConversationMembersQueryVo = imConversationMembersService.getImConversationMembersById(id);
//        return ApiResult.ok(imConversationMembersQueryVo);
//    }
//


}

