package com.wecloud.im.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.wecloud.im.entity.ImInbox;
import com.wecloud.im.param.ImMsgReadStatusUpdate;
import com.wecloud.im.param.ImMsgReceivedStatusUpdate;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.BaseService;

/**
 * 消息收件箱表 服务类
 *
 * @author wei
 * @since 2021-05-06
 */
public interface ImInboxService extends BaseService<ImInbox> {

//        /**
//         * 保存
//         *
//         * @param imInbox
//         * @return
//         * @throws Exception
//         */
//        boolean saveImInbox(ImInbox imInbox) throws Exception;
//
//        /**
//         * 修改
//         *
//         * @param imInbox
//         * @return
//         * @throws Exception
//         */
//        boolean updateImInbox(ImInbox imInbox) throws Exception;
//
//        /**
//         * 删除
//         *
//         * @param id
//         * @return
//         * @throws Exception
//         */
//        boolean deleteImInbox(Long id) throws Exception;
//
//        /**
//         * 根据ID获取查询对象
//         *
//         * @param id
//         * @return
//         * @throws Exception
//         */
//        ImInboxQueryVo getImInboxById(Long id) throws Exception;
//
//        /**
//         * 获取分页对象
//         *
//         * @param imInboxPageParam
//         * @return
//         * @throws Exception
//         */
//        Paging<ImInboxQueryVo> getImInboxPageList(ImInboxPageParam imInboxPageParam) throws Exception;


        /**
         * 消息修改为已接收状态
         *
         * @param imMsgReceivedUpdate
         * @return
         */
        ApiResult<Boolean> updateImMsgReceived(ImMsgReceivedStatusUpdate imMsgReceivedUpdate);

        /**
         * 统计未读消息数量
         *
         * @param clientId
         * @return
         */
        Integer countMyNotReadCount(Long clientId);

        /**
         * 消息修改为已读状态
         *
         * @return
         */
        ApiResult<Boolean> updateImMsgRead(ImMsgReadStatusUpdate imMsgReadStatusUpdate) throws JsonProcessingException;

}
