package com.wecloud.im.service;

import com.wecloud.im.entity.ImApplication;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.shiro.signature.Application;

/**
 * 第三方应用表 服务类
 *
 * @author wei
 * @since 2021-04-27
 */
public interface ImApplicationService extends BaseService<ImApplication> {


    /**
     * 根据id查询应用数据 redis缓存
     *
     * @param id
     * @return
     */
    ImApplication getCacheById(Long id);

    /**
     * 根据appKey查询application
     *
     * @param appKey
     * @return
     */
    ImApplication getCacheAppByAppKey(String appKey);

    /**
     * 本地构造
     * @return
     */
    ImApplication getByLocal();

}
