package com.jumeirah.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jumeirah.common.entity.VersionControl;
import com.jumeirah.common.param.VersionControlPageParam;
import com.jumeirah.common.param.VersionControlQueryVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;

/**
 * App版本控制 Mapper 接口
 *
 * @author giao
 * @since 2020-10-26
 */
@Repository
public interface VersionControlMapper extends BaseMapper<VersionControl> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    VersionControlQueryVo getVersionControlById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param versionControlPageParam
     * @return
     */
    IPage<VersionControlQueryVo> getVersionControlPageList(@Param("page") Page page, @Param("param") VersionControlPageParam versionControlPageParam);

}
