package com.jumeirah.api.app.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jumeirah.common.entity.VersionControl;
import com.jumeirah.common.service.VersionControlService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * App版本控制 控制器
 * <p>
 * 仅查询最新创建的一条版本数据返回给App
 *
 * @author giao
 * @since 2020-10-26
 */
@Slf4j
@RestController
@RequestMapping("/app/versionControl")
@Api(value = "App版本控制API", tags = {"App版本控制"})
public class VersionControlController extends BaseController {

    @Autowired
    private VersionControlService versionControlService;

//    /**
//     * 添加App版本控制
//     */
//    @PostMapping("/add")
//    @OperationLog(name = "添加App版本控制", type = OperationLogType.ADD)
//    @ApiOperation(value = "添加App版本控制")
//    public ApiResult<Boolean> addVersionControl(@Validated(Add.class) @RequestBody VersionControl versionControl) throws Exception {
//        boolean flag = versionControlService.saveVersionControl(versionControl);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 修改App版本控制
//     */
//    @PostMapping("/update")
//    @OperationLog(name = "修改App版本控制", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改App版本控制")
//    public ApiResult<Boolean> updateVersionControl(@Validated(Update.class) @RequestBody VersionControl versionControl) throws Exception {
//        boolean flag = versionControlService.updateVersionControl(versionControl);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 删除App版本控制
//     */
//    @PostMapping("/delete/{id}")
//    @OperationLog(name = "删除App版本控制", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除App版本控制")
//    public ApiResult<Boolean> deleteVersionControl(@PathVariable("id") Long id) throws Exception {
//        boolean flag = versionControlService.deleteVersionControl(id);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 获取App版本控制详情
//     */
//    @GetMapping("/info/{id}")
//    @OperationLog(name = "App版本控制详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "App版本控制详情")
//    public ApiResult<VersionControlQueryVo> getVersionControl(@PathVariable("id") Long id) throws Exception {
//        VersionControlQueryVo versionControlQueryVo = versionControlService.getVersionControlById(id);
//        return ApiResult.ok(versionControlQueryVo);
//    }
//
//    /**
//     * App版本控制分页列表
//     */
//    @PostMapping("/getPageList")
//    @OperationLog(name = "App版本控制分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "App版本控制分页列表")
//    public ApiResult<Paging<VersionControlQueryVo>> getVersionControlPageList(@Validated @RequestBody VersionControlPageParam versionControlPageParam) throws Exception {
//        Paging<VersionControlQueryVo> paging = versionControlService.getVersionControlPageList(versionControlPageParam);
//        return ApiResult.ok(paging);
//    }

    /**
     * 获取最新一条版本记录
     */
    @GetMapping("/lastOne/{type}")
//    @OperationLog(name = "获取最新一条版本记录", type = OperationLogType.INFO)
    @ApiOperation(value = "获取最新一条版本记录")
    public ApiResult<VersionControl> lastOne(@PathVariable Integer type) throws Exception {
        VersionControl versionControlQueryVo = versionControlService.getOne(
                new QueryWrapper<VersionControl>().lambda()
                        .eq(VersionControl::getDeviceType, type)
                        .orderByDesc(VersionControl::getCreateTime).last("limit 1")
        );
        return ApiResult.ok(versionControlQueryVo);
    }


}

