package com.wecloud.im.sdk.model.message;

import lombok.Getter;
import lombok.Setter;

import com.wecloud.im.sdk.enums.MessageTypeEnum;

/**
 * 位置类型消息
 * @Author luozh
 * @Date 2022年05月07日 13:59
 * @Version 1.0
 */
public class LocationMessage extends WecloudImBaseMessage {
    public LocationMessage() {
        super(MessageTypeEnum.POSITION);
    }

    @Setter
    @Getter
    public static class MetaData {

        /**
         * 经度
         */
        private Double longitude;

        /**
         * 纬度
         */
        private Double latitude;
    }

    public void setMetaData(MetaData metaData) {
        this.put("metaData", metaData);
    }
}
