package com.wecloud.im.sdk.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import cn.hutool.core.lang.Assert;

/**
 * 拓展属性
 * @Author luozh
 * @Date 2022年05月19日 16:30
 * @Version 1.0
 */
public class Attributes extends HashMap<String, Object> {

    final Map<String, Object> attributes;

    public Attributes() {
        attributes = new HashMap<>(8);
    }

    public Attributes(Map<String, Object> attributes) {
        Assert.notNull(attributes, "MultiValueMap must not be null");
        this.attributes = attributes;
    }

    public void add(String key, Object value) {
        this.attributes.put(key, value);
    }

    // Map implementation

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.attributes.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.attributes.containsValue(value);
    }


    @Override
    public Object get(Object key) {
        return this.attributes.get(key);
    }


    @Override
    public Object put(String key, Object value) {
        return this.attributes.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.attributes.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        this.attributes.putAll(map);
    }

    @Override
    public void clear() {
        this.attributes.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.attributes.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.attributes.values();
    }

    @Override
    public Set<Entry<String, Object>> entrySet() {
        return this.attributes.entrySet();
    }


    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Attributes)) {
            return false;
        }
        Attributes otherAttributes = (Attributes) other;
        return this.attributes.equals(otherAttributes.attributes);
    }

    @Override
    public int hashCode() {
        return this.attributes.hashCode();
    }

}
