package com.wecloud.im.sdk.model;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author Future
 * @Date 2022/5/22 23:40
 * @Description 单人音视频记录表
 */
@Data
@Accessors(chain = true)
public class ImRtcRecord implements Serializable {

    private static final long serialVersionUID = -523597842194055670L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 应用appid
     */
    private Long fkAppid;

    /**
     * 频道id
     */
    private Long channelId;

    /**
     * 发起方id
     */
    private String fromClientId;

    /**
     * 接收方id
     */
    private String toClientId;

    /**
     * 频道状态，1：音视频发起，2：音视频中，3：音视频结束
     */
    private Integer state;

    /**
     * 通话类型 1音频 2视频
     */
    private Integer callType;

    /**
     * 音视频开始时间
     */
    private Date startTime;

    /**
     * 音视频结束时间
     */
    private Date endTime;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date updateTime;

}
