package io.geekidea.springbootplus.test;

import com.wecloud.im.entity.ImConversation;
import com.wecloud.im.entity.ImConversationMembers;
import com.wecloud.im.service.ImConversationMembersService;
import com.wecloud.im.service.ImConversationService;
import com.wecloud.utils.SnowflakeUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.util.Date;

/**
 * imConversation 单元测试
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class ImConversationMembersTest {

    @Autowired
    private ImConversationMembersService imConversationMembersService;

    @Autowired
    private ImConversationService imConversationService;

    @Test
    public void addConversation() {
        long creator = 1390920735408656384L;
        long user2 = 1390921236443435008L;
        long appid = 1387022761016299520L;
        Long imConversationId = SnowflakeUtil.getId();

        // 创建会话
        ImConversation imConversation = new ImConversation();
        imConversation.setId(imConversationId);
        imConversation.setCreateTime(new Date());
        imConversation.setLastMessage(null);
        imConversation.setFkAppid(appid);
        imConversation.setCreator(creator);
        imConversation.setName("");
        imConversation.setAttributes("");
        imConversation.setSystemFlag(false);
        imConversationService.save(imConversation);

        // 将自己添加到会话
        Long imConversationMembersId = SnowflakeUtil.getId();
        ImConversationMembers imConversationMembers = new ImConversationMembers();
        imConversationMembers.setId(imConversationMembersId);
        imConversationMembers.setCreateTime(new Date());
//        imConversationMembers.setUpdateTime(new Date());
        imConversationMembers.setFkAppid(appid);
        imConversationMembers.setFkConversationId(imConversationId);
        imConversationMembers.setFkClientId(creator);
        imConversationMembersService.save(imConversationMembers);

        // 将他人添加到会话
        Long imConversationMembersId2 = SnowflakeUtil.getId();
        ImConversationMembers imConversationMembers2 = new ImConversationMembers();
        imConversationMembers2.setId(imConversationMembersId2);
        imConversationMembers2.setCreateTime(new Date());
        imConversationMembers2.setFkAppid(appid);
        imConversationMembers2.setFkConversationId(imConversationId);
        imConversationMembers2.setFkClientId(user2);
        imConversationMembersService.save(imConversationMembers2);
    }
}
