package io.geekidea.springbootplus.scheduled;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.wecloud.im.entity.ImInbox;
import com.wecloud.im.service.ImInboxService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @Author Future
 * @Date 2022/9/27 14:29
 * @Description 离线消息
 */
@Slf4j
@Component
public class InboxScheduled {

    @Autowired
    private ImInboxService imInboxService;

    /**
     * 离线消息处理定时器
     * 一个月之前的离线消息直接删除
     * 一星期前的已读消息 删除
     * 一天执行一次 凌晨3点执行
     */
    @Scheduled(cron = "* */10 * * * ?")
    public void callingTimeout() {
        log.info("离线消息处理定时器处理开始...");
        // 30天之前数据， 直接删除
        Date allDeleteTime = DateUtils.addDays(new Date(), -30);
        imInboxService.remove(new QueryWrapper<ImInbox>().lambda()
                .lt(ImInbox::getCreateTime, allDeleteTime));

        // 7天之前数据， 删除已读消息
        Date readTime = DateUtils.addDays(new Date(), -7);
        imInboxService.remove(new QueryWrapper<ImInbox>().lambda()
                .eq(ImInbox::getReadMsgStatus, 1)
                .lt(ImInbox::getCreateTime, readTime));
    }

}
