package com.wecloud.im.param;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author wenzhida
 * @Date 2022/2/16 17:32
 * @Description 设置群管理员入参
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "设置群管理员入参")
public class SetAdminsParam extends BaseEntity {

    private static final long serialVersionUID = -5998535761252546365L;

    @ApiModelProperty("会话表id")
    private Long conversationId;

    @ApiModelProperty("要设置为群管理员的clientId列表")
    private List<String> clientIds;

    @NotNull(message = "操作类型")
    @ApiModelProperty("操作类型 1-设置管理员 2-删除管理员")
    private Integer operateType;

}
