package com.jumeirah.common.controller;

import com.jumeirah.common.entity.PlainType;
import com.jumeirah.common.service.PlainTypeService;
import lombok.extern.slf4j.Slf4j;
import com.jumeirah.common.param.PlainTypePageParam;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import com.jumeirah.common.vo.PlainTypeQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.common.param.IdParam;
import io.geekidea.springbootplus.framework.log.annotation.Module;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 飞机型号表 控制器
 *
 * @author wei
 * @since 2020-10-09
 */
/*@Slf4j
@RestController
@RequestMapping("/plainType")
@Module("${cfg.module}")
@Api(value = "飞机型号表API", tags = {"飞机型号表"})*/
public class PlainTypeController extends BaseController {

    @Autowired
    private PlainTypeService plainTypeService;

    /**
     * 添加飞机型号表
     */
    @PostMapping("/add")
    @OperationLog(name = "添加飞机型号表", type = OperationLogType.ADD)
    @ApiOperation(value = "添加飞机型号表", response = ApiResult.class)
    public ApiResult<Boolean> addPlainType(@Validated(Add.class) @RequestBody PlainType plainType) throws Exception {
        boolean flag = plainTypeService.savePlainType(plainType);
        return ApiResult.result(flag);
    }

    /**
     * 修改飞机型号表
     */
    @PostMapping("/update")
    @OperationLog(name = "修改飞机型号表", type = OperationLogType.UPDATE)
    @ApiOperation(value = "修改飞机型号表", response = ApiResult.class)
    public ApiResult<Boolean> updatePlainType(@Validated(Update.class) @RequestBody PlainType plainType) throws Exception {
        boolean flag = plainTypeService.updatePlainType(plainType);
        return ApiResult.result(flag);
    }

    /**
     * 删除飞机型号表
     */
    @PostMapping("/delete/{id}")
    @OperationLog(name = "删除飞机型号表", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除飞机型号表", response = ApiResult.class)
    public ApiResult<Boolean> deletePlainType(@PathVariable("id") Long id) throws Exception {
        boolean flag = plainTypeService.deletePlainType(id);
        return ApiResult.result(flag);
    }

    /**
     * 获取飞机型号表详情
     */
    @GetMapping("/info/{id}")
    @OperationLog(name = "飞机型号表详情", type = OperationLogType.INFO)
    @ApiOperation(value = "飞机型号表详情", response = PlainTypeQueryVo.class)
    public ApiResult<PlainTypeQueryVo> getPlainType(@PathVariable("id") Long id) throws Exception {
        PlainTypeQueryVo plainTypeQueryVo = plainTypeService.getPlainTypeById(id);
        return ApiResult.ok(plainTypeQueryVo);
    }

    /**
     * 飞机型号表分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "飞机型号表分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "飞机型号表分页列表", response = PlainTypeQueryVo.class)
    public ApiResult<Paging<PlainTypeQueryVo>> getPlainTypePageList(@Validated @RequestBody PlainTypePageParam plainTypePageParam) throws Exception {
        Paging<PlainTypeQueryVo> paging = plainTypeService.getPlainTypePageList(plainTypePageParam);
        return ApiResult.ok(paging);
    }

}

