package com.wecloud.im.appmanager;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.service.ImApplicationService;
import com.wecloud.im.ws.utils.KeyGenerator;
import com.wecloud.imserver.client.api.ImApplicationFacade;
import com.wecloud.imserver.client.model.ao.CreateApplicationAO;
import com.wecloud.imserver.client.model.ao.ListApplicationQueryAO;
import com.wecloud.imserver.client.model.ao.UpdateAppSecretAO;
import com.wecloud.imserver.client.model.dto.ApplicationDTO;
import com.wecloud.imserver.client.model.dto.Result;
import com.wecloud.imserver.client.model.dto.UpdateAppSecretDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author nanqianhao
 * @date 2022/5/26
 * @apiNote
 */
@Slf4j
@Service
@DubboService
public class ImApplicationFacadeImpl implements ImApplicationFacade {

    @Autowired
    private ImApplicationService imApplicationService;



    @Override
    public Result<UpdateAppSecretDTO> updateAppSecret(UpdateAppSecretAO updateSecretAO) {
        log.info("更新Secret传入参数为{}",updateSecretAO);
        String appKey = updateSecretAO.getAppKey();
        ImApplication application = imApplicationService.getOne(new LambdaQueryWrapper<ImApplication>().eq(ImApplication::getAppKey, appKey));
        String appSecret = KeyGenerator.getAppSecret();
        UpdateAppSecretDTO updateAppSecretDTO = new UpdateAppSecretDTO();
        updateAppSecretDTO.setNewAppSecret(appSecret);
        application.setAppSecret(appSecret);
        imApplicationService.updateById(application);
        log.info("更新Secret返回结果为{}",updateAppSecretDTO);
        return Result.getSuccessResult(updateAppSecretDTO);
    }

    @Override
    public Result<Boolean> createApplication(CreateApplicationAO createApplicationAO) {
        log.info("创建应用传入的参数为{}",createApplicationAO);
        String appKey = KeyGenerator.getRandomString();
        String appSecret = KeyGenerator.getAppSecret();
        ImApplication imApplication = new ImApplication();
        if (createApplicationAO.getTenantId()==null||"".equals(createApplicationAO.getTenantId())){
            return Result.getBusinessException("请传入租户id", null);
        }
        long id = IdWorker.getId();
        imApplication.setId(id);
        imApplication.setTenantId(createApplicationAO.getTenantId());
        imApplication.setAppKey(appKey);
        imApplication.setAppSecret(appSecret);
        imApplication.setAppName(createApplicationAO.getAppName());
        imApplication.setCreateTime(new Date());
        log.info("新建的应用信息为{}",imApplication);
        boolean saveResult = imApplicationService.save(imApplication);
        return Result.getSuccessResult(saveResult);
    }

    @Override
    public Result<List<ApplicationDTO>> listApplications(ListApplicationQueryAO listApplicationQueryAO) {
        log.info("查看应用列表传入的参数为{}",listApplicationQueryAO);
        if (listApplicationQueryAO.getTenantId()==null||"".equals(listApplicationQueryAO.getTenantId())){
            return Result.getBusinessException("请传入租户id", null);
        }
        List<ImApplication> list = imApplicationService.list(new LambdaQueryWrapper<ImApplication>().eq(ImApplication::getTenantId, listApplicationQueryAO.getTenantId()));
        List<ApplicationDTO> applicationDTOs = new ArrayList<>();
        list.forEach(ImApplication->{
            ApplicationDTO applicationDTO = new ApplicationDTO();
            BeanUtils.copyProperties(ImApplication,applicationDTO);
            applicationDTOs.add(applicationDTO);
        });
        log.info("返回的应用列表为{}",applicationDTOs);
        return Result.getSuccessResult(applicationDTOs);
    }

    @Override
    public Result<Boolean> updateApplication(CreateApplicationAO createApplicationAO) {
        log.info("编辑应用传入参数为{}",createApplicationAO);
        ImApplication application = imApplicationService.getOne(new LambdaQueryWrapper<ImApplication>().eq(ImApplication::getId, createApplicationAO.getId()));
        application.setAppName(createApplicationAO.getAppName());
        application.setUpdateTime(new Date());
        boolean updateResult = imApplicationService.updateById(application);
        log.info("编辑的应用信息为{}",application);
        return Result.getSuccessResult(updateResult);
    }
}
