package com.wecloud.imserver.client.api;

import com.wecloud.imserver.client.model.ao.CreateApplicationAO;
import com.wecloud.imserver.client.model.ao.ListApplicationQueryAO;
import com.wecloud.imserver.client.model.ao.UpdateAppSecretAO;
import com.wecloud.imserver.client.model.dto.ApplicationDTO;
import com.wecloud.imserver.client.model.dto.Result;
import com.wecloud.imserver.client.model.dto.UpdateAppSecretDTO;

import java.util.List;

/**
 * @author nanqianhao
 * @date 2022/5/26
 * @apiNote
 */
public interface ImApplicationFacade {

    /**
     * 更新Secret
     * @param updateSecretAO
     * @return
     */
    Result<UpdateAppSecretDTO> updateAppSecret(UpdateAppSecretAO updateSecretAO);

    /**
     * 创建应用
     * @param createApplicationAO
     * @return
     */
    Result<Boolean>createApplication(CreateApplicationAO createApplicationAO);

    /**
     * 查看应用
     * @param listApplicationQueryAO
     * @return
     */
    Result<List<ApplicationDTO>> listApplications(ListApplicationQueryAO listApplicationQueryAO);

    /**
     * 编辑应用
     * @param createApplicationAO
     * @return
     */
    Result<Boolean> updateApplication(CreateApplicationAO createApplicationAO);
}
