package com.wecloud.im.externalaccess.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author wenzhida
 * @Date 2022/3/3 17:42
 * @Description 多人音视频sign获取入参
 */
@Data
public class MultiMeetSignGetParam implements Serializable {

    private static final long serialVersionUID = 1538118936608500035L;

    @ApiModelProperty("时间戳")
    @NotNull(message = "时间戳不能为空")
    private String timestamp;

    @ApiModelProperty("client客户端id")
    @NotNull(message = "client客户端id不能为空")
    private String clientId;

    @ApiModelProperty("appKey")
    @NotNull(message = "appKey不能为空")
    private String appKey;

    @ApiModelProperty("客户端平台: 1 web, 2 安卓, 3 ios, 4 pc-win, 5 pc-macOs")
    @NotNull(message = "客户端平台不能为空")
    private Integer platform;

    @ApiModelProperty("密钥")
    @NotNull(message = "密钥不能为空")
    private String appSecret;

}
