package com.wecloud.im.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <pre>
 * 消息收件箱表 查询结果对象
 * </pre>
 *
 * @author wei
 * @date 2021-05-06
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "ImInboxQueryVo对象")
public class ImInboxQueryVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("收件id")
    private Long id;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("接收时间")
    private Date receiverDate;

    @ApiModelProperty("应用appid")
    private Long fkAppid;

    @ApiModelProperty("接收客户端id")
    private Long receiver;

    @ApiModelProperty("消息id")
    private Long fkMsgId;

    @ApiModelProperty("0未读; 1已读")
    private Boolean read;

    @ApiModelProperty("会话id")
    private Long fkConversationId;
}