package com.wecloud.im.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImConversation;
import com.wecloud.im.param.ImConversationPageParam;
import com.wecloud.im.param.ImConversationQueryVo;
import com.wecloud.im.vo.MyConversationListVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;
import java.util.List;

/**
 * 会话表 Mapper 接口
 *
 * @author wei
 * @since 2021-05-07
 */
@Repository
public interface ImConversationMapper extends BaseMapper<ImConversation> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    ImConversationQueryVo getImConversationById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param imConversationPageParam
     * @return
     */
    IPage<ImConversationQueryVo> getImConversationPageList(@Param("page") Page page, @Param("param") ImConversationPageParam imConversationPageParam);


    /**
     * 查询用户加入的所有会话 与每个会话的未读条数 成员
     *
     * @param clientId
     * @return
     */
    List<MyConversationListVo> getMyImConversationListAndMsgCount(@Param("clientId") Long clientId);

    /**
     * 查询用户加入的所有会话
     *
     * @param clientId
     * @return
     */
    List<ImConversation> getMyImConversationList(@Param("clientId") Long clientId);

    /**
     * 判断两个客户端是否存在会话
     *
     * @param clientId1
     * @param clientId2
     * @return
     */
    Integer getRepetitionConversation(@Param("clientId1") Long clientId1, @Param("clientId2") Long clientId2);

    /**
     * 判断重复会话中的Attributes是否一样
     *
     * @param clientId1
     * @param clientId2
     * @param attributes
     * @return 大于等于1为有重复会话
     */
    Long getRepetitionConversationAttributes(@Param("clientId1") Long clientId1, @Param("clientId2") Long clientId2, @Param("attributes") String attributes);


    /**
     * 查询已经存在的一对一会话信息
     *
     * @param clientId1
     * @param clientId2
     * @return
     */
    ImConversation getRepetitionConversationInfo(@Param("clientId1") Long clientId1, @Param("clientId2") Long clientId2);

    /**
     * 增减成员数量
     * @param appId fkAppid
     * @param conversationId 会话id
     * @param addCount 要增减的人数， 负数是减
     * @return
     */
    boolean addMemberCount(@Param("appId") Long appId, @Param("conversationId") Long conversationId, @Param("addCount") int addCount);

    /**
     * 升级成万人群
     * @param appId fkAppId
     * @param conversationId 会话id
     * @return 成功则返回true
     */
    boolean upgradeToThousandChat(@Param("appId") Long appId, @Param("conversationId") Long conversationId);
}
