package com.wecloud.im.param.add;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 添加或修改推送设备信息
 *
 * @author wei
 * @since 2021-04-27
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "添加或修改推送设备信息")
public class ImClientDeviceInfoAdd extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("设备不想收到推送提醒, 1想, 0不想")
    private Integer valid;

    @ApiModelProperty("设备类型1:ios; 2:android")
    private Integer deviceType;

    @ApiModelProperty("设备推送token")
    private String deviceToken;
}
