package com.wecloud.im.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Data
@Accessors(chain = true)
@ApiModel(value = "ImConversationMemberListVo")
public class ConversationMemberVo implements Serializable {

    private static final long serialVersionUID = 7278014943001080361L;

    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("会话中client的备注名")
    private String clientRemarkName;
    @ApiModelProperty("头像")
    private String headPortrait;
    @ApiModelProperty("主昵称")
    private String nickname;
    @ApiModelProperty("clientId")
    private String clientId;
    @ApiModelProperty("client自己的自定义扩展属性")
    private String clientAttributes;
    @ApiModelProperty("会话成员列表的自定义扩展属性")
    private String memberAttributes;

    /**
     * 群内角色
     * @see com.wecloud.im.enums.GroupRoleEnum
     */
    @ApiModelProperty("群内角色")
    private Integer role;

    /**
     * 禁言开关
     * @see com.wecloud.im.enums.MutedEnum
     */
    @ApiModelProperty("禁言开关 1-未禁言 2-禁言")
    private Integer muted;

}
