package com.wecloud.im.user.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author wenzhida
 * @Date 2022/2/21 18:15
 * @Description 生成验证码入参
 */
@Data
public class SendVerifyCodeParam implements Serializable {

    private static final long serialVersionUID = 565144491185523650L;

    /**
     * 电话号码
     */
    @NotNull(message = "电话号码不可为空")
    @ApiModelProperty("电话号码")
    private String phone;

    /**
     * 验证场景 1-用户注册 2-重置密码验证 3-更换手机号绑定
     * @see com.wecloud.im.enums.VerifySceneEnum
     */
    @NotNull(message = "验证场景不可为空")
    @ApiModelProperty("验证场景 1-用户注册 2-重置密码验证 3-更换手机号绑定")
    private Integer verifyScene;

}
