package com.wecloud.im.netty.core;

import com.wecloud.im.app_ws.model.WsConstants;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class NettyChannelInitializer extends ChannelInitializer<SocketChannel> {
    @Resource
    private ChannelInboundHandler channelInboundHandler;

    @Override
    protected void initChannel(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        // http
        pipeline.addLast(new HttpServerCodec());
        pipeline.addLast(new ChunkedWriteHandler());
        pipeline.addLast(new HttpObjectAggregator(2048576000));

        // 服务端api接口
        pipeline.addLast("SingleHttpRequestHandler", channelInboundHandler);

        // 连接超时管理 (判断通道是否有数据写入)
        pipeline.addLast("readTimeoutHandler", new ReadTimeoutHandler(60));

        // "/appws"路径 升级长连接
        pipeline.addLast("appWebSocketServerotocolHandler", new WebSocketServerProtocolHandler(WsConstants.WS_URL));
    }

}
