package com.wecloud.im.app_ws.enums;

/**
 * @Description ws响应类型
 * @Author hewei hwei1233@163.com
 * @Date 2019-12-05
 */
public enum WsResponseCmdEnum {

    /**
     * 离线消息下发完成指令
     */
    OFFLINE_MSG_SUC(100),

    /**
     * 主动下发消息指令
     */
    WRITE_MSG(101);

    private final int cmdCode;

    WsResponseCmdEnum(int uriCode) {
        this.cmdCode = uriCode;
    }

    /**
     * 根据uriCode获取
     *
     * @param uriCode
     * @return
     */
    public static WsResponseCmdEnum getByCode(int uriCode) {
        for (WsResponseCmdEnum wsResponsePathEnum : values()) {
            if (wsResponsePathEnum.getCmdCode() == uriCode) {
                return wsResponsePathEnum;
            }
        }
        return null;
    }

    public int getCmdCode() {
        return cmdCode;
    }
}
