package io.geekidea.springbootplus.test;

import cn.hutool.core.codec.Base64;
import com.wecloud.im.entity.ImIosApns;
import com.wecloud.im.service.ImIosApnsService;
import com.wecloud.im.ws.sender.IosPush;
import com.wecloud.utils.SnowflakeUtil;
import io.geekidea.springbootplus.SpringBootPlusApplication;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.io.InputStream;

/**
 * 生成apns字符串 并存入数据库
 */
@SpringBootTest(classes = SpringBootPlusApplication.class)
@RunWith(SpringRunner.class)
public class SaveApnsTest {


    @Autowired
    private ImIosApnsService imIosApnsService;

    @Test
    public void test() throws Exception {

        String apnsCertificatePath = "ChatSdk_ios.p12";
        String topicBundleId = "com.wecloud.chatDemo";
        String pwd = "123456";


        InputStream certificate = IosPush.getApnsCertificate(apnsCertificatePath);
        String encode = Base64.encode(certificate);


        ImIosApns imIosApns = new ImIosApns();
        imIosApns.setId(SnowflakeUtil.getId());
        imIosApns.setFkAppId(0L);
        imIosApns.setApnsFileValue(encode);
        imIosApns.setEnv(1);
        imIosApns.setBundleId(topicBundleId);
        imIosApns.setPwd(pwd);

        imIosApnsService.save(imIosApns);
    }
}
