package com.wecloud.im.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <pre>
 * 消息存储表 查询结果对象
 * </pre>
 *
 * @author wei
 * @date 2021-04-29
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "ImMessageQueryVo对象")
public class ImMessageQueryVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("消息id")
    private Long id;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("撤回时间")
    private Date withdrawTime;

    @ApiModelProperty("修改时间")
    private Date updateDate;

    @ApiModelProperty("应用appid")
    private Long fkAppid;

    @ApiModelProperty("发送者客户端id")
    private Long sender;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("0未撤回; 1已撤回")
    private Boolean withdraw;

    @ApiModelProperty("0非事件; 1为事件")
    private Boolean event;

    @ApiModelProperty("0非系统通知; 1为系统通知")
    private Boolean system;

    @ApiModelProperty("at他人,传入客户端id数组")
    private String at;

    @ApiModelProperty("发送状态, 0AVIMMessageStatusNone（未知） 1AVIMMessageStatusSending（发送中） 2AVIMMessageStatusSent（发送成功） 3AVIMMessageStatusReceipt（被接收） 4AVIMMessageStatusFailed（失败）")
    private Integer sendStatus;

    @ApiModelProperty("类型" +
            "类型 文本消息-1" +
            "图像消息-2" +
            "音频消息-3" +
            "视频消息-4" +
            "位置消息-5" +
            "文件消息-6" +
            "以上类型均使用负数，所有正数留给自定义扩展类型使用，0 作为「没有类型」被保留起来。")
    private Integer type;

    @ApiModelProperty("会话id")
    private Long fkConversationId;
}