package com.wecloud.im.controller;

import com.wecloud.im.entity.ImMessage;
import com.wecloud.im.param.ImMessagePageParam;
import com.wecloud.im.param.ImMessageQueryVo;
import com.wecloud.im.service.ImMessageService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 消息存储表 控制器
 *
 * @author wei
 * @since 2021-04-29
 */
@Slf4j
@RestController
@RequestMapping("/imMessage")
@Api(value = "消息存储表API", tags = {"消息存储表"})
public class ImMessageController extends BaseController {

    @Autowired
    private ImMessageService imMessageService;

    /**
     * 添加消息存储表
     */
    @PostMapping("/add")
    @OperationLog(name = "添加消息存储表", type = OperationLogType.ADD)
    @ApiOperation(value = "添加消息存储表")
    public ApiResult<Boolean> addImMessage(@Validated(Add.class) @RequestBody ImMessage imMessage) throws Exception {
        boolean flag = imMessageService.saveImMessage(imMessage);
        return ApiResult.result(flag);
    }

    /**
     * 修改消息存储表
     */
    @PostMapping("/update")
    @OperationLog(name = "修改消息存储表", type = OperationLogType.UPDATE)
    @ApiOperation(value = "修改消息存储表")
    public ApiResult<Boolean> updateImMessage(@Validated(Update.class) @RequestBody ImMessage imMessage) throws Exception {
        boolean flag = imMessageService.updateImMessage(imMessage);
        return ApiResult.result(flag);
    }

    /**
     * 删除消息存储表
     */
    @PostMapping("/delete/{id}")
    @OperationLog(name = "删除消息存储表", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除消息存储表")
    public ApiResult<Boolean> deleteImMessage(@PathVariable("id") Long id) throws Exception {
        boolean flag = imMessageService.deleteImMessage(id);
        return ApiResult.result(flag);
    }

    /**
     * 获取消息存储表详情
     */
    @GetMapping("/info/{id}")
    @OperationLog(name = "消息存储表详情", type = OperationLogType.INFO)
    @ApiOperation(value = "消息存储表详情")
    public ApiResult<ImMessageQueryVo> getImMessage(@PathVariable("id") Long id) throws Exception {
        ImMessageQueryVo imMessageQueryVo = imMessageService.getImMessageById(id);
        return ApiResult.ok(imMessageQueryVo);
    }

    /**
     * 消息存储表分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "消息存储表分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "消息存储表分页列表")
    public ApiResult<Paging<ImMessageQueryVo>> getImMessagePageList(@Validated @RequestBody ImMessagePageParam imMessagePageParam) throws Exception {
        Paging<ImMessageQueryVo> paging = imMessageService.getImMessagePageList(imMessagePageParam);
        return ApiResult.ok(paging);
    }

}

