package com.wecloud.im.sdk.model.message;

import lombok.Data;
import lombok.Getter;
import lombok.Setter;

/**
 * 音频消息
 * @Author luozh
 * @Date 2022年05月07日 14:05
 * @Version 1.0
 */
@Data
public class MessageVideoFile {

    /**
     * 地址
     */
    private String url;

    /**
     * 元数据
     */
    private MetaData metaData;

    @Setter
    @Getter
    public static class MetaData {
        /**
         * 文件的名称
         */
        private String name;

        /**
         * 视频的格式
         */
        private String format;

        /**
         * 时长 单位秒 精确小数点后1位
         */
        private Double duration;

        /**
         * 高度(单位 像素)
         */
        private Integer height;

        /**
         * 宽度(单位 像素)
         */
        private Integer width;

        /**
         * 大小 单位b
         */
        private Integer size;
    }
}
