package com.wecloud.im.externalaccess.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import com.wecloud.im.sdk.enums.DeviceTypeEnum;

/**
 * @Author wenzhida
 * @Date 2022/2/21 18:15
 * @Description 用户登录入参
 */
@Data
public class UserLoginParam implements Serializable {

    private static final long serialVersionUID = 9182337935301787778L;

    /**
     * 电话号码
     */
    @NotNull(message = "电话号码不可为空")
    @ApiModelProperty("电话号码")
    private String phone;

    /**
     * 密码
     */
    @NotNull(message = "密码不可为空")
    @ApiModelProperty("密码")
    private String password;

    @NotNull(message = "appKey不可为空")
    @ApiModelProperty("appKey")
    private String appKey;

    /**
     * 设备类型
     * @see DeviceTypeEnum
     */
    @NotNull(message = "设备类型不可为空")
    @ApiModelProperty("设备类型 1:ios; 2:android; 3:web; 4:win; 5:mac")
    private Integer deviceType;

}
