package com.wecloud.im.enums;

import io.geekidea.springbootplus.framework.common.enums.BaseEnum;

/**
 * @Author wenzhida
 * @Date 2022/3/15 23:16
 * @Description 多人音视频房间状态枚举
 */
public enum MultiRtcRoomStateEnum implements BaseEnum {

    /**
     * 1 - 已创建
     */
    CREATED(1, "已创建"),

    /**
     * 2 - 会议中
     */
    MEETING(2, "会议中"),

    /**
     * 3 - 会议结束
     */
    END(3, "会议结束");

    MultiRtcRoomStateEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final Integer code;
    private final String desc;


    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}
