package com.wecloud.im.action;

import com.wecloud.dispatch.annotation.ActionMapping;
import com.wecloud.im.enums.CallTypeEnum;
import com.wecloud.im.param.rtc.*;
import com.wecloud.im.ws.model.WsResponse;
import com.wecloud.rtc.service.RtcService;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.enums.BaseEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;

@Slf4j
@Component
@ActionMapping(value = "/im/rtc")
@Api(value = "ws-音视频通话", tags = {"音视频通话"})
public class RtcAction {

    @Autowired
    private RtcService rtcService;

    /**
     * 创建频道,并邀请客户端加入
     */
    @ActionMapping("/createAndCall")
    @ApiOperation(value = "创建频道,并邀请客户端加入", notes = "创建频道,并邀请客户端加入")
    public WsResponse<CreateRtcChannelResult> createAndCall(@RequestBody CreateRtcChannelParam createRtcChannelParam) {
        if (BaseEnum.valueOf(CallTypeEnum.class, createRtcChannelParam.getCallType()) == null) {
            return WsResponse.fail(ApiCode.PARAMETER_EXCEPTION);
        }
        return WsResponse.ok(rtcService.createAndCall(createRtcChannelParam));
    }


    @ActionMapping("/join")
    @ApiOperation(value = "同意进入频道", notes = "")
    public WsResponse<Boolean> join(@RequestBody JoinRtcChannelParam joinRtcChannelParam) {
        rtcService.join(joinRtcChannelParam);
        return WsResponse.ok();
    }

    @ActionMapping("/reject")
    @ApiOperation(value = "拒接进入频道", notes = "")
    public WsResponse<Boolean> reject(@RequestBody RejectRtcChannelParam rejectRtcChannelParam) {
        rtcService.reject(rejectRtcChannelParam);
        return WsResponse.ok();
    }

    @ActionMapping("/leave")
    @ApiOperation(value = "主动挂断(离开频道)", notes = "")
    public WsResponse<Boolean> leave(@RequestBody LeaveRtcChannelParam leaveRtcChannelParam) {
        rtcService.leave(leaveRtcChannelParam);
        return WsResponse.ok();
    }

    @ActionMapping("/sdpForward")
    @ApiOperation(value = "SDP数据转发", notes = "")
    public WsResponse<Boolean> sdpForward(@RequestBody SdpForwardParam sdpForwardParam) {
        rtcService.sdpForward(sdpForwardParam);
        return WsResponse.ok();
    }

    @ActionMapping("/candidateForward")
    @ApiOperation(value = "candidate候选者数据转发", notes = "")
    public WsResponse<Boolean> candidateForward(@RequestBody CandidateForwardParam candidateForwardParam) {
        rtcService.candidateForward(candidateForwardParam);
        return WsResponse.ok();
    }
}
