package com.wecloud.im.service;

import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.entity.ImMessage;
import com.wecloud.im.param.ChatContentVo;
import com.wecloud.im.param.ImClientSimpleDto;
import com.wecloud.im.param.ImHistoryMessagePageParam;
import com.wecloud.im.param.add.ImMsgRecall;
import com.wecloud.im.param.add.ImMsgSendToOnlineClient;
import com.wecloud.im.param.add.ImMsgUpdate;
import com.wecloud.im.vo.ImMessageOfflineListVo;
import com.wecloud.im.vo.OfflineMsgDto;
import com.wecloud.im.ws.model.request.ReceiveDataVO;
import com.wecloud.im.ws.model.request.ReceiveVO;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 消息存储表 服务类
 *
 * @author wei
 * @since 2021-04-29
 */
public interface ImMessageService extends BaseService<ImMessage> {


    /**
     * 下发透传消息
     *
     * @param imMsgSendToOnlineClient
     * @return
     */
    ApiResult<Boolean> restApiImMessageSend(ImMsgSendToOnlineClient imMsgSendToOnlineClient, ImApplication imApplication);


    ImMessage saveImMessage(ImApplication imApplication, ImClient imClientSender, long messageId, ReceiveVO receiveVO, ReceiveDataVO sysParam);


    @Transactional(rollbackFor = Exception.class)
    ImMessage saveImMessage(ImClientSimpleDto client, long messageId, ChatContentVo data);

    /**
     * 消息撤回 只能撤回客户端自己发送的消息
     *
     * @return
     */
    ApiResult<Boolean> updateMsgWithdrawById(ImMsgRecall imMsgRecall);

    /**
     * 修改消息体
     *
     * @param imMsgUpdate
     * @return
     */
    ApiResult<Boolean> updateMsgById(ImMsgUpdate imMsgUpdate);

    /**
     * 查询某个会话历史消息分页列表
     *
     * @param imHistoryMessagePageParam
     * @return
     * @throws Exception
     */
    Paging<OfflineMsgDto> getHistoryMsgConversationId(ImHistoryMessagePageParam imHistoryMessagePageParam) throws Exception;

    /**
     * 查询用户所有离线消息
     *
     * @return
     * @throws Exception
     */
    List<ImMessageOfflineListVo> getOfflineList() throws Exception;

    /**
     * 根据客户端id与会话id 查询离线消息
     *
     * @param clientId
     * @param conversationId
     * @return
     */
    List<OfflineMsgDto> getOfflineListByClientAndConversation(Long clientId, Long conversationId);


    /**
     * 查询会话的最后一条消息
     *
     * @param conversationId
     * @return
     */
    OfflineMsgDto getLastMsgByConversationId(Long conversationId);

    /**
     * 查询会话接收的最后一条消息
     *
     * @param clientId
     * @param conversationId
     * @return
     */
    OfflineMsgDto getReceivedLastMsgByConversationId(Long clientId, Long conversationId);

    /**
     * 保存
     *
     * @param imMessage
     * @return
     * @throws Exception
     */
    boolean saveImMessage(ImMessage imMessage) throws Exception;

//        /**
//         * 修改
//         *
//         * @param imMessage
//         * @return
//         * @throws Exception
//         */
//        boolean updateImMessage(ImMessage imMessage) throws Exception;
//
//    /**
//     * 删除
//     *
//     * @param id
//     * @return
//     * @throws Exception
//     */
//    boolean deleteImMessage(Long id) throws Exception;
//
//    /**
//     * 根据ID获取查询对象
//     *
//     * @param id
//     * @return
//     * @throws Exception
//     */
//    ImMessageQueryVo getImMessageById(Long id) throws Exception;
//
//    /**
//     * 获取分页对象
//     *
//     * @param imMessagePageParam
//     * @return
//     * @throws Exception
//     */
//    Paging<ImMessageQueryVo> getImMessagePageList(ImMessagePageParam imMessagePageParam) throws Exception;
}
